﻿/*	version: 1.1	
	1.1		Altered internal reactTo(), added parameters so that it reacts to dispatchEvent() calls

*/
var createMapCollection = function( newData, allowEvents )
{
	var allowEvents = (allowEvents!==undefined) ? allowEvents : true;		// allow events unless told not to
	
	var current = {};
	//current.data		// Initializes below.  Uses data.create.map() by default.
	
	var data = {};
	data.chipsets = {};
	data.collision = {};
	data.layers = {};
	data.any = {};
	//data.any.alreadyTriggered = false;
	
	AsBroadcaster.initialize( data.any );
	AsBroadcaster.initialize( data );
	AsBroadcaster.initialize( data.chipsets );
	AsBroadcaster.initialize( data.collision );
	AsBroadcaster.initialize( data.layers );
	
	var announceAnyChange = updateOnce( function( evt ){
		data.any.broadcastMessage("change", evt );
	});// updateOnce announceAnyChange()		(will only run once per call-sequence)
	
	
	data.addChangedFunc = function( newData, addedEvtData ){
		var evt = {};
		evt.type = "change";
		evt.target = this;			// usually over-written by addEvtData's evt.target
		// add additional data to evt object
		for(var nam in addedEvtData){
			evt[nam] = addedEvtData[nam];
		}
		this.broadcastMessage("change", evt );
		
		// data.any shouldn't auto-react to itself changing
		if(this !== data.any){
			announceAnyChange( evt );
		}
	}// changed()
	
	data.any.changed = data.addChangedFunc;
	data.changed = data.addChangedFunc;
	data.chipsets.changed = data.addChangedFunc;
	data.collision.changed = data.addChangedFunc;
	data.layers.changed = data.addChangedFunc;
	
	/*
	Use evt.target to avoid reacting to your own changes:
		if( evt.target == map_mc )	return;		// don't react to your own changes
	
	When announcing a change to data:
		data.layers.changed( current.data.layers, {target:map_mc} );
		if mapEvents change the data, then they'll claim their event object is responsible & check for that upon reactTo()
	*/
	
	
	
	// Data interaction commands
	data.get = {};
	data.set = {};
	data.create = {};
	data.add = {};
	data.remove = {};
	data.copy = {};
	data.modify = {};
	// // create containers for each format
	var formats = new Array(4);
	for(var f=0; f<formats.length; f++){
		formats[f] = {};
		formats[f].get = {};
		formats[f].set = {};
		formats[f].create = {};
		formats[f].add = {};
		formats[f].remove = {};
		formats[f].copy = {};
		formats[f].modify = {};
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	// FORMAT:  1  (format 2 decompressed)
	#include "map/format1.as"
	
	// FORMAT:  3
	#include "map/format3.as"
	
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	// initialize settings
	newData = newData || formats[3].create.map();		// default to map3
	changeFormat( newData.format );		// setup an initial interface
	data.set.data( newData );
	
	
	
	
	
	// EVENTS
	if( allowEvents ){
		
		var eventReactions = selfCleanupEvents( _this );
		eventReactions.reactTo( _this, null, "onFormatChanged" ).onFormatChanged = function( evt ){
			// collection detected format change
			// switch data interface based on map format  (set.data() invokes changeFormat()
			data.set.data( current.data );
		}// onFormatChanged()
	}// allowed to listen to events
	
	
	// Swap map interface... based on map format
	function changeFormat( newFormat ){
		// Formats 1 & 2 are actually the same format.
		// Very old maps don't have a "format" variable, but are actually format 1.
		if(newFormat == 2 || newFormat == undefined)		newFormat = 1;
		
		// clear previous interface;
		for(var nam in data.get){
			data.get[nam]	= null;		}
		for(var nam in data.set){
			data.set[nam] = null;		}
		for(var nam in data.create){
			data.create[nam] = null;		}
		for(var nam in data.add){
			data.add[nam] = null;		}
		for(var nam in data.remove){
			data.remove[nam] = null;		}
		for(var nam in data.copy){
			data.copy[nam] = null;		}
		for(var nam in data.modify){
			data.modify[nam] = null;		}
		
		// switch data interface based on map format
		var newCommands = formats[newFormat];
		for(var nam in newCommands.get){
			data.get[nam] = newCommands.get[nam];		}
		for(var nam in newCommands.set){
			data.set[nam] = newCommands.set[nam];		}
		for(var nam in newCommands.create){
			data.create[nam] = newCommands.create[nam];		}
		for(var nam in newCommands.add){
			data.add[nam] = newCommands.add[nam];		}
		for(var nam in newCommands.remove){
			data.remove[nam] = newCommands.remove[nam];		}
		for(var nam in newCommands.copy){
			data.copy[nam] = newCommands.copy[nam];		}
		for(var nam in newCommands.modify){
			data.modify[nam] = newCommands.modify[nam];		}
	}// onFormatChanged()
	
	
	return data;
}// createMapCollection()